require( "scripts/style.lua" );


barheight = 100;
bartop = 600 - barheight;

inv_x = 237;
inv_y = 553 - bartop;	-- kCenter;

midbar_y = 520 - bartop;	-- for pause and diary buttons

magic_x = 592;
arrow_left_x = -70;
arrow_right_x = 70;

inv_h = 60; -- was 84 but that goes off the bottom of the world
iflags = kVAlignTop + kHAlignCenter;
iflags = kVAlignCenter + kHAlignCenter;

--[[
ABORTSPEC = 
Button 
{
	align = kHAlignRight,
	x = kMax,
	y = 10,
	
	font = StandardButtonFont,
	graphics = StandardButtonGraphics,
	name="bye",
	label="bye",
	type = kPush,
	command = function()
		scene:AbortConversation();
	end
};
--]]

--
-- Diary button
-- 		
DIARYBUTTONSPEC =
Button
{
	name = "DiaryButton",
	--label = "diary",
	type = kPush,
	x = 720,
	y = midbar_y,
	align = kVAlignCenter + kHAlignCenter,
	flags = kVAlignCenter + kHAlignCenter,
	command = function()
		EnterPause();
		dfSetStatus("++DiaryAccesses");
		DoModal("diary/primary.lua");
		ExitPause();
	end,
	graphics = 
	{
		"buttons/interface_diary_btn",
		"buttons/interface_diary_btn_clicked",
		"buttons/interface_diary_btn_mouseover"
	},
	
	mask = "buttons/interface_diary_btn_mask",
};

--
-- Pause button
-- 		
PAUSEBUTTONSPEC =
Button
{
	x = 725, 
	y = midbar_y+5,
	--align = kVAlignCenter + kHAlignCenter,
	--flags = kVAlignCenter + kHAlignCenter,
	font = StandardButtonFont,
	graphics = 
	{
		"buttons/button_pause_up",
		"buttons/button_pause_down",
		"buttons/button_pause_over"
	},
	name="pause",
	--label="pause",
	type = kPush,
	command= function()
		EnterPause();
		DoModal("scripts/pause.lua");
		ExitPause();
	end,
	mask = "buttons/button_pause_mask",
};

--
-- "return" button
-- 		
RETURNBUTTONSPEC =
Button
{
	x = kMax - 10,
	y = 10,
	align = kVAlignTop + kHAlignRight,
	
	font = StandardButtonFont,
	graphics = StandardButtonGraphics,
	name="return",
	label="return",
	type = kPush,
	command = function()
		scene:ReturnFromScene();
	end
};


--
-- Inventory description button
-- 	
INVDESCTEXTSPEC =
Text
{
	x = kCenter,
	y = inv_y - 7,
	w = 200,
	h = 54,
	flags = kVAlignCenter + kHAlignCenter,
	label="",
	name = "inv_desc",
	font =
	{
		standardFont,
		22, 
		WhiteColor,
	},
};

--[[
		Button	-- test button
		{
			x = 1,
			y = 1,
			align = kHAlignCenter + kVAlignCenter,
			graphics = { "inv/inventory_icon" },
		},
--]]

--
-- Inventory button and arrows
-- 	
INVENTORYBARSPEC =
Window
{
	name = "BAG_INV_super",
	x = 50, y = 524 - bartop,
	w = 450, h = 59,
	
	Button
	{
		name = "BAG_INV_left",
		x = 0,
		y = kCenter,
		align = kVAlignCenter + kHAlignLeft,
		graphics =
		{	
			"buttons/inv_left",
			"buttons/inv_left_clicked",
			"buttons/inv_left_mouseover"
		},
		command = function()
			BAG_INV:MoveInventory(-1);
		end
	},
	
	Button
	{
		name = "BAG_INV_right",
		x = kMax,
		y = kCenter,
		align = kVAlignCenter + kHAlignRight,
		graphics = 
		{
			"buttons/inv_right",
			"buttons/inv_right_clicked",
			"buttons/inv_right_mouseover"
		},
		command = function()
			BAG_INV:MoveInventory(1);
		end
	},

	Window
	{
		x = kCenter, y = 0,
		w = 450, h = kMax,
		
		align = kHAlignCenter;
		
		tIconStrip
		{
			name = "BAG_INV_strip",
			x = 0, y = 0,
			h = inv_h,

			maxicons = 8,
			visibleicons = 8,
			iconbase = "BAG_INV_obj",
			ibase_x = -2,
			igap_x = 59,

			bag = BAG.BAG_INV;				
			icongen = function(bag, index)
				return function() 
					if game:CanUseInventory(bag, index) then
						sfx:PlaySFX("audio/sfx/pickup_item.ogg");
						game:UseInventory(bag, index); 
					end
				end;
			end;
		},
	}
};

--[[
MAGICBARSPEC =
Window
{
	name = "BAG_MAGIC_super",
	x = 545, y = 500 - bartop,
	w = 183, h = 100,
	
	Button
	{
		name = "BAG_MAGIC_left",
		x = 0,
		y = kCenter,
		align = kVAlignCenter + kHAlignLeft,
		graphics =
		{	
			"buttons/mag_left",
			"buttons/mag_left_clicked",
			"buttons/mag_left_mouseover"
		},
		command = function()
			BAG_MAGIC:MoveInventory(-1);
		end
	},
	
	Button
	{
		name = "BAG_MAGIC_right",
		x = kMax,
		y = kCenter,
		align = kVAlignCenter + kHAlignRight,
		graphics = 
		{
			"buttons/mag_right",
			"buttons/mag_right_clicked",
			"buttons/mag_right_mouseover"
		},
		command = function()
			BAG_MAGIC:MoveInventory(1);
		end
	},

	Window
	{
		x = kCenter, y = 4,
		w = 143, h = kMax,
		
		align = kHAlignCenter;
		
		tIconStrip
		{
			name = "BAG_MAGIC_strip",
			x = 0, y = 0,
			h = inv_h,

			maxicons = 15,
			visibleicons = 4,
			iconbase = "BAG_MAGIC_obj",
			ibase_x = -2,
			igap_x = 38,

			bag = BAG.BAG_MAGIC;				
			icongen = function(bag, index)
				return function() 
					if game:CanUseInventory(bag, index) then
						game:UseInventory(bag, index); 
					end
				end;
			end;
			
			font = EnterNameFont,
		},
	}
};
--]]

INTERCEPTSPEC =
tIntercept
{
	x = 0,
	y = kMax,
	h = 85,
	w = kMax,
	name = "INTERCEPTSPEC",
	align = kVAlignBottom,
	command = function()
		-- nothing
	end,
	
	mask = "buttons/interface_background_mask",
	
	Window
	{
		name = "LOWBARBITMAP",
		x = 0,
		y = 0,
		w = kMax,
		h = kMax,
		
		--DIARYBUTTONSPEC,
		--PAUSEBUTTONSPEC,
		--INVDESCTEXTSPEC,
		INVENTORYBARSPEC,
		--MAGICBARSPEC,
	},
	
};

GWSPEC =
{
	x = kCenter,
	y = kCenter,
	w = kMax,
	h = kMax,
	alpha = false,
	name = "gwspec",
	
	tSubGame { x = kCenter, y = kCenter, w = 430, h = 293, name = "SUBWINDOW" },
	
-- don't allow the conversation abort button to show up
--	ABORTSPEC,	

	-- pieces which are pulled from quest/hud/pieces.xml
	tAtlasImage { name = "HUDBG", x = 0, y = 0, w = kMax, h = kMax, frame = "interface_background" };
	--tAtlasImage { x = 0, y = 0, w = kMax, h = kMax, frame = "bigbar_0a" };
	--tAtlasImage { x = 0, y = 0, w = kMax, h = kMax, frame = "bigbar_0b" };
	--tAtlasImage { x = 0, y = 0, w = kMax, h = kMax, frame = "bigbar_2a" };
	--tAtlasImage { x = 0, y = 0, w = kMax, h = kMax, frame = "bigbar_2b" };
	--tAtlasImage { x = 0, y = 0, w = kMax, h = kMax, frame = "bigbar_1" };
	--tAtlasImage { x = 0, y = 0, w = kMax, h = kMax, frame = "bigbar_3" };
		
	INTERCEPTSPEC,
};

-- Our mini-game set-up
MakeDialog
{
	-- Name the modal dialog
	name = "gametop",
	alpha = false,

	Window
	{
		x = 0,
		y = 0,
		w = 800,
		h = 600,
		alpha = false,
		name = "gameframe",
		TGame(GWSPEC),
	},
	TOverhud { x = 0, y = 0, w = 800, h = 600 },
}

scene:ModifySaySpec
{
	y = 100,	h = 100,
	x = 100,	w = 600,
};

--SetHUDEnable(IsHUDEnabled());